#pragma once

#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include "tools.h"
#include "contentlist.h"
#include "scngames.h"

using namespace std;

class CGenreList : CXuiListImpl
{
public:

    XUI_IMPLEMENT_CLASS( CGenreList, L"GenreList", XUI_CLASS_LIST );

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
		XUI_ON_XM_GET_SOURCE_TEXT(OnGetSourceDataText)
		XUI_ON_XM_GET_ITEMCOUNT_ALL(OnGetItemCountAll)
		XUI_ON_XM_GET_SOURCE_IMAGE(OnGetSourceDataImage)
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
	HRESULT OnGetSourceDataText(XUIMessageGetSourceText *pGetSourceTextData, BOOL& bHandled);
	HRESULT OnGetItemCountAll(XUIMessageGetItemCount *pGetItemCountData, BOOL& bHandled);
	HRESULT OnGetSourceDataImage(XUIMessageGetSourceImage *pGetSourceImageData,  BOOL& bHandled);
};

class CScnGenres : public CXuiSceneImpl
{

protected:
    // Message map.
	CXuiList m_list;
	CXuiList m_gameslist;
	CXuiTextElement m_title;
	CXuiControl m_abutton;
	CXuiControl m_xbutton;
	CXuiControl m_bbutton;
	/*CXuiImageElement m_cover;
	CXuiImageElement m_ss1;
	CXuiImageElement m_ss2;
	CXuiTextElement m_desc;*/
	CXuiTextElement m_freemem;
	CXuiTextElement m_gamesingenre;
	CXuiTextElement m_date;
	CXuiTextElement m_time;
	CXuiTextElement m_datetime;

    XUI_BEGIN_MSG_MAP()
        XUI_ON_XM_INIT( OnInit )
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
        XUI_ON_XM_NOTIFY_SELCHANGED( OnNotifySelChanged )
		XUI_ON_XM_NOTIFY_SET_FOCUS( OnNotifySetFocus )
		XUI_ON_XM_TIMER( OnTimer )
	XUI_END_MSG_MAP()

    //----------------------------------------------------------------------------------
    // Performs initialization tasks - retreives controls.
    //----------------------------------------------------------------------------------
    HRESULT OnInit( XUIMessageInit* pInitData, BOOL& bHandled );
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
	HRESULT OnNotifySelChanged( HXUIOBJ hObjSource, XUINotifySelChanged* pNotifySelChangedData, BOOL& bHandled );
	HRESULT OnNotifySetFocus( HXUIOBJ hObjSource, XUINotifyFocus *pNotifyFocusData, BOOL& bHandled );
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );

public:
	void ListSel(int curSel);

    // Define the class. The class name must match the ClassOverride property
    // set for the scene in the UI Authoring tool.
    XUI_IMPLEMENT_CLASS( CScnGenres, L"ScnGenres", XUI_CLASS_TABSCENE )
};
